--  
require( "scripts/game/deftasks.lua" );
require( "scripts/game/deftime.lua" );
GameObject = {
    Params = {
        ID="lemonad";
        image="lemonad4";
        width=0;
        height=0;
        timerTask=-1;
        TimerFramesCount = 8;
        Personages = {"dad", "mother","sister"};
        glass_count = 1;
        GridData = { 
            1
        };
        RandomTasks=1;
    };
    ActivePoints = { 
        make = { 
                   { {}, 1,0,0,  0,  1,0,0 };
                }; 
        drink = { 
                   { {}, 1,0,0,  0,  1,0,0 };
                }; 
    };
    Objects = {};
    --     
    Tasks = {
        make = { FuncName="MakeTaskExecute",  timer=7, time_tick=1000, not_need_action=1 };
        drink = { FuncName="DrinkTaskExecute", timer=1, time_tick=300, not_need_action=1, hand_add=1 };  
    };
    --     
    Triggers = { };
    --      
    InitActiveTasks = {};
    --      
    InitExpectedTasks = {};
};

function GameObject:Get()
    return self;
end

function GetParams()
    aObj = GameObject:Get();   
    return aObj.Params;
end

function OnInit()
    CPP_SetAnimState("no_glass");
end


function MakeTaskExecute()
    local aObject = GameObject:Get();
    local tTask = aObject.Params.timerTask;
    
    if (tTask < 0 ) then 
       tTask = aObject.Tasks.make.timer; 
    end
        
    

    CPP_SetAnimState("time_"..(aObject.Tasks.make.timer - tTask));
    tTask = tTask - 1;
    
    
    aObject.Params.timerTask = tTask;
    if (tTask <= 0) then
            aObject.Params.timerTask = -1;
            aObject.Params.GlassCount = aObject.Params.glass_count;
            CPP_SetAnimState("two_glass");
            CPP_SetAnimState("value1_"..aObject.Params.GlassCount);
            if( not PersCash)then PersCash={}; end
            
            for i = 1, table.getn(aObject.Params.Personages) do           
                local pers = aObject.Params.Personages[i];
                if( not PersCash[pers])then
                    PersCash[pers] = CPP_FindObj(pers);
                    if( PersCash[pers] ==0)then PersCash[pers] = nil; end
                end
                
                if( PersCash[pers]~=nil )then
                    CPP_RunStringSubId( PersCash[pers],  "LemonadIsReady()");
                end
            end
                      
            CPP_PutOnTopExpectedTasks("drink");
            CPP_WantSelect(1);           
            CPP_PlaySound("lemonade_completed",0);
        return 0;
    end   
    --aObject = GameObject:Get();
    --CPP_WantSelect(1);
    return 1;
end

function DrinkTaskExecute()
    local aObject = GameObject:Get();
    AddStatParamI("LemonadeUsed",1);
    aObject.Params.GlassCount = aObject.Params.GlassCount - 1;
    if( aObject.Params.GlassCount > 0)then
        CPP_PutOnTopExpectedTasks("drink");
        CPP_WantSelect(1);               
        CPP_SetAnimState("one_glass");        
        CPP_SetAnimState("value1_"..aObject.Params.GlassCount);
    else
        CPP_SetAnimState("no_glass");
        CPP_WantSelect(1);
    end;
    
    return 0;
end



